/**
 * Solution simplifiee pour le probleme de distance
 * Ce script se concentre uniquement sur le probleme essentiel
 */

document.addEventListener('DOMContentLoaded', function() {
  console.log("=== SOLUTION SIMPLIFIEE POUR LES DISTANCES ===");
  
  // Fonction pour mettre a jour directement les elements de distance
  function updateDistanceElement(id, distance) {
    console.log(`Mise a jour distance ID ${id}: ${distance} km`);
    
    // Formater la distance avec 1 decimale
    const formattedDistance = parseFloat(distance).toFixed(1);
    
    // Mettre a jour dans la vue liste
    const distanceElement = document.getElementById(`distance-${id}`);
    if (distanceElement) {
      const valueElement = distanceElement.querySelector('.distance-value');
      if (valueElement) {
        valueElement.textContent = formattedDistance;
        valueElement.style.color = 'red';
        valueElement.style.fontWeight = 'bold';
        distanceElement.style.display = 'flex';
      }
    }
    
    // Mettre a jour dans la vue grille
    const gridDistanceElement = document.getElementById(`grid-distance-${id}`);
    if (gridDistanceElement) {
      const gridValueElement = gridDistanceElement.querySelector('.grid-distance-value');
      if (gridValueElement) {
        gridValueElement.textContent = formattedDistance;
        gridValueElement.style.color = 'red';
        gridValueElement.style.fontWeight = 'bold';
        gridDistanceElement.style.display = 'flex';
      }
    }
  }
  
  // Intercepter les appels fetch pour capturer les reponses de l'API
  const originalFetch = window.fetch;
  window.fetch = function(url, options) {
    // Verifier si c'est un appel a notre API de distance
    if (url && typeof url === 'string' && url.includes('/get-distance.php')) {
      console.log(`Appel API detecte: ${url}`);
      
      // Extraire les coordonnees de destination pour identifier l'element
      let endCoords = null;
      try {
        const urlObj = new URL(url, window.location.origin);
        endCoords = urlObj.searchParams.get('end');
      } catch (e) {
        // Fallback pour les navigateurs qui ne supportent pas URL
        const endMatch = url.match(/end=([^&]+)/);
        if (endMatch) endCoords = decodeURIComponent(endMatch[1]);
      }
      
      // Trouver l'ID correspondant aux coordonnees
      let targetId = null;
      if (endCoords) {
        // Convertir au format attendu par data-coordinates
        const [endLng, endLat] = endCoords.split(',');
        const dataCoords = `${endLat},${endLng}`;
        
        // Chercher l'element avec ces coordonnees
        document.querySelectorAll('[data-coordinates]').forEach(item => {
          if (item.getAttribute('data-coordinates') === dataCoords) {
            targetId = item.getAttribute('data-id');
          }
        });
      }
      
      // Appeler l'API et intercepter la reponse
      return originalFetch(url, options).then(response => {
        // Cloner la reponse pour pouvoir la lire
        const responseClone = response.clone();
        
        responseClone.text().then(text => {
          try {
            const data = JSON.parse(text);
            console.log('Reponse API:', data);
            
            // Verifier si la reponse contient une distance
            if (data.features && 
                data.features[0] && 
                data.features[0].properties && 
                data.features[0].properties.summary && 
                typeof data.features[0].properties.summary.distance === 'number') {
              
              // Convertir de metres en kilometres
              const distanceKm = data.features[0].properties.summary.distance / 1000;
              console.log(`Distance calculee: ${distanceKm.toFixed(1)} km`);
              
              // Si on a trouve l'ID, mettre a jour l'element
              if (targetId) {
                console.log(`Mise a jour pour ID ${targetId}`);
                updateDistanceElement(targetId, distanceKm);
                
                // Stocker la distance dans l'attribut data-distance pour le tri
                document.querySelectorAll(`[data-id="${targetId}"]`).forEach(item => {
                  item.setAttribute('data-distance', distanceKm);
                });
              } else {
                console.log('ID non trouve pour ces coordonnees');
              }
            } else if (data.error) {
              console.error(`Erreur API: ${data.error}`);
            }
          } catch (error) {
            console.error('Erreur parsing JSON:', error);
          }
        });
        
        // Retourner la reponse originale
        return response;
      });
    }
    
    // Pour les autres URL, utiliser fetch normal
    return originalFetch(url, options);
  };
  
  // Ajouter un gestionnaire d'evenements au bouton de geolocalisation
  document.querySelectorAll('.geolocation-button').forEach(button => {
    button.addEventListener('click', function() {
      console.log('Clic sur le bouton de geolocalisation');
      
      // Verifier si des distances ont ete calculees apres 5 secondes
      setTimeout(function() {
        const distanceElements = document.querySelectorAll('.distance-value, .grid-distance-value');
        console.log(`Verification de ${distanceElements.length} elements de distance`);
        
        distanceElements.forEach(element => {
          const value = parseFloat(element.textContent);
          if (value === 0 || isNaN(value)) {
            console.log('Distance zero detectee, verification de la reponse API');
          }
        });
      }, 5000);
    });
  });
  
  console.log("=== SOLUTION SIMPLIFIEE INITIALISEE ===");
});
